/****************************************************************************************
  *
  * ļ  main.c
  *     ChipON_AE/FAE_Group
  *     2019-11-16
  *     ļṩCCP׽ģʽӦ̲ο
  *
 ****************************************************************************************/
#include "system_init.h"


volatile uint16_t UP_PLUSE_WIDTH =0;//׽PWMռձȱ
volatile uint16_t DW_PLUSE_WIDTH =0;//׽PWMڱ



//ʱ ֲvolatileܻᱻŻ
// 1msʱ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}


/**
  *   CCPx ׽ӳá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *     GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *    PinRemap: ӳѡ
  *   ޡ
  */
void CCPx_Capture_GPIO_Init(GPIO_SFRmap* GPIOx,uint16_t GpioPin,uint8_t PinRemap)
{
	 static uint16_t GpioPinNum;
	  GPIO_Reset(GPIOx);                //λGPIOGPIOʱ

//	//////////////////////////////////////////////////////////////
	GPIO_Write_Mode_Bits(GPIOx,GpioPin,GPIO_MODE_RMP);  //GPIOΪӳ书

	if(GpioPin==GPIO_PIN_MASK_0)
	{
		GpioPinNum =GPIO_Pin_Num_0;
	}else if(GpioPin==GPIO_PIN_MASK_1)
	{
		GpioPinNum =GPIO_Pin_Num_1;
	}else if(GpioPin==GPIO_PIN_MASK_2)
	{
		GpioPinNum =GPIO_Pin_Num_2;
	}else if(GpioPin==GPIO_PIN_MASK_3)
	{
		GpioPinNum =GPIO_Pin_Num_3;
	}else if(GpioPin==GPIO_PIN_MASK_4)
	{
		GpioPinNum =GPIO_Pin_Num_4;
	}else if(GpioPin==GPIO_PIN_MASK_5)
	{
		GpioPinNum =GPIO_Pin_Num_5;
	}else if(GpioPin==GPIO_PIN_MASK_6)
	{
		GpioPinNum =GPIO_Pin_Num_6;
	}else if(GpioPin==GPIO_PIN_MASK_7)
	{
		GpioPinNum =GPIO_Pin_Num_7;
	}else if(GpioPin==GPIO_PIN_MASK_8)
	{
		GpioPinNum =GPIO_Pin_Num_8;
	}else if(GpioPin==GPIO_PIN_MASK_9)
	{
		GpioPinNum =GPIO_Pin_Num_9;
	}else if(GpioPin==GPIO_PIN_MASK_10)
	{
		GpioPinNum =GPIO_Pin_Num_10;
	}else if(GpioPin==GPIO_PIN_MASK_11)
	{
		GpioPinNum =GPIO_Pin_Num_11;
	}else if(GpioPin==GPIO_PIN_MASK_12)
	{
		GpioPinNum =GPIO_Pin_Num_12;
	}else if(GpioPin==GPIO_PIN_MASK_13)
	{
		GpioPinNum =GPIO_Pin_Num_13;
	}else if(GpioPin==GPIO_PIN_MASK_14)
	{
		GpioPinNum =GPIO_Pin_Num_14;
	}else if(GpioPin==GPIO_PIN_MASK_15)
	{
		GpioPinNum =GPIO_Pin_Num_15;
	}

	GPIO_Pin_RMP_Config(GPIOx,GpioPinNum,PinRemap);  //GPIOӳ蹦
}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}



/**
  *   CCPx׽ͨ1ͨ2ʼ
  *  : CCPx: ָCCPͨöʱڴṹָ룬
  *               ȡֵCCP0_SFR/CCP1_SFR/CCP2_SFR/CCP3_SFR/CCP4_SFR/
  *               CCP18_SFR/CCP19_SFR/CCP20_SFR/CCP21_SFR/CCP22_SFR/CCP23_SFR
  *   ޡ
  */
void CCPx_Capture_Mode_init(CCP_SFRmap* CCPx)
{
	TIM_Reset(CCPx);										//ʱ踴λʹʱ
	CCP_PWM_Input_Measurement_Config(CCPx,TRUE);            //PWMģʽʹ
	GPTIM_Slave_Mode_Config(CCPx,GPTIM_SLAVE_RESET_MODE);   //ôģʽλģʽ
	GPTIM_Trigger_Select_Config(CCPx,GPTIM_TRIGGER_CCPXCH1);
	CCP_Capture_Mode_Config(CCPx, CCP_CHANNEL_1,CCP_CAP_FALLING_EDGE);      ///ò׽ͨ ģʽ:ÿ½ط׽
	CCP_Capture_Mode_Config(CCPx, CCP_CHANNEL_2,CCP_CAP_RISING_EDGE);       ///ò׽ͨ ģʽ:ÿط׽


	GPTIM_Updata_Immediately_Config(CCPx,TRUE);				//¿
	GPTIM_Updata_Enable(CCPx,TRUE);							//øʹ
	GPTIM_Work_Mode_Config(CCPx,GPTIM_TIMER_MODE);			//ʱģʽѡ
	GPTIM_Set_Counter(CCPx,0);								//ʱֵ

	GPTIM_Set_Prescaler(CCPx,47);							//ʱԤƵֵ ԤƵΪ47+1=48Ƶʱ48,1usһ
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_OF);		//-¼,жϱ־
	GPTIM_Clock_Config(CCPx,GPTIM_SCLK);					//ѡSCLKʱΪʱʱԴ
	GPTIM_Cmd(CCPx,TRUE);                                   //ʹͨöʱ

}





//
void main()
{
	/*ûɲοKF32LS200_demoʵֲ׽ģʽùܡ
	 * Ӧ CCPxCHy ŷ¼ʱCCPx_Cy Ĵ׽ Tx Ĵֵ
	 * ʹCCP2ģʵֲ׽ģʽ1KHZ ռձΪ50%PWMźţ
	 * ͨ1׽ȷPWMźźPF0ת,DEMOSTATUS˸,ӳ䵽ͨ2׽ȷռձPF4ת
	 */
	//ϵͳʱ48M,Ƶʱ16M
	SystemInit();
	//ʼPF0PF4ߵƽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0|GPIO_PIN_MASK_4);

	 //ӳ䲶׽IO  PH11ΪCCP2_CH1   PH10ΪCCP2_CH2
	CCPx_Capture_GPIO_Init(GPIOH_SFR,GPIO_PIN_MASK_11,GPIO_RMP_AF1_T2);
	CCPx_Capture_GPIO_Init(GPIOH_SFR,GPIO_PIN_MASK_10,GPIO_RMP_AF1_T2);

	//CCP2 ͨ 1 ͨ2 ׽ģʽʼ
	CCPx_Capture_Mode_init(CCP2_SFR);// ʱ48M,1usһ

    while(1)
    {
    	delay_ms(200);
    	delay_ms(200);
		//1KHZ PWMźŵļ
    	UP_PLUSE_WIDTH	= CCP_Get_Capture_Result(CCP2_SFR,CCP_CHANNEL_1);			//׽ռձ
		if((UP_PLUSE_WIDTH >480)&&(UP_PLUSE_WIDTH<520))                             //1KHZPWMźţռձΪ50%
			GPIO_Toggle_Output_Data_Config(GPIOF_SFR,GPIO_PIN_MASK_4);              //ռձƥPF4ת

		DW_PLUSE_WIDTH	= CCP_Get_Capture_Result(CCP2_SFR,CCP_CHANNEL_2);			//׽
		if((DW_PLUSE_WIDTH >980)&&(DW_PLUSE_WIDTH<1020))                            //1KHZPWMźżֵ
			GPIO_Toggle_Output_Data_Config(GPIOF_SFR,GPIO_PIN_MASK_0);              //ֵƥPF0ת
    }


}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

