/**
  ******************************************************************************
  * ļ  SPI.c
  *     ChipON_AE/FAE_Group
  *     2019-10-19
  *     ļṩSPI DMAعܣ
  *          + SPI
  *          + SPI_DMA
  *
  ******************************************************************************/
#include "system_init.h"
#include "SPI.h"
volatile uint8_t  Command_flag;//־λ
volatile uint8_t  Dummy_flag;  //dummy־λ
volatile uint8_t  Uart_flag;   //ڱ־λ
volatile uint32_t Tx_length;   //ͳȱ
volatile uint32_t Rx_length;   //ճȱ
uint8_t Tx_master[BufferSize] = "KF32L530-KungFu32 SPI Example master";  //Tx
uint8_t Tx_slave[BufferSize]  = "KF32L530-KungFu32 SPI Example slaves";  //ӻTx
uint8_t Read_data[BufferSize]; //ݻ

/**
  *     SPI
  *    SPIxָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *    
  */
void SPI_Init_Configuration(SPI_SFRmap* SPIx)
{
	SPI_InitTypeDef newStruct_SPI;
	/*SPI*/
#if SPI_MASTER
	newStruct_SPI.m_Mode = SPI_MODE_MASTER_CLKDIV4;                   //ģʽʱ4Ƶ 18M
#else
	newStruct_SPI.m_Mode = SPI_MODE_SLAVE;                            //ģʽ
#endif
 	newStruct_SPI.m_Clock = SPI_CLK_SCLK;							  //SPIƵʱ
	newStruct_SPI.m_FirstBit = SPI_FIRSTBIT_MSB;					  //MSB
	newStruct_SPI.m_CKP = SPI_CKP_LOW;                                //SCKΪ
	newStruct_SPI.m_CKE = SPI_CKE_1EDGE;                              //һʱӿʼ
	newStruct_SPI.m_DataSize = SPI_DATASIZE_8BITS;                    //8bit
	newStruct_SPI.m_BaudRate = 0x59;                                  //Fck_spi=Fck/2(m_BaudRate+1)=10us
    SPI_Reset(SPIx);											      //λģ
    SPI_Configuration(SPIx, &newStruct_SPI);					      //дṹ
	SPI_Cmd(SPIx,TRUE);											      //ʹ
}


/**
  *     SPI_DMA
  *    SPIxָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *    
  */
void SPI_DMA_Configuration(SPI_SFRmap* SPIx)
{
	SPI_InitTypeDef newStruct_SPI;
	/*SPI*/
#if SPI_MASTER
	newStruct_SPI.m_Mode = SPI_MODE_MASTER_CLKDIV4;                   //ģʽʱ4Ƶ 18M
#else
	newStruct_SPI.m_Mode = SPI_MODE_SLAVE;                            //ģʽ
#endif
 	newStruct_SPI.m_Clock = SPI_CLK_SCLK;							  //SPIƵʱ
	newStruct_SPI.m_FirstBit = SPI_FIRSTBIT_MSB;					  //MSB
	newStruct_SPI.m_CKP = SPI_CKP_LOW;                                //SCKΪ
	newStruct_SPI.m_CKE = SPI_CKE_1EDGE;                              //һʱӿʼ
	newStruct_SPI.m_DataSize = SPI_DATASIZE_8BITS;                    //8bit
	newStruct_SPI.m_BaudRate = 0x59;                                  //Fck_spi=Fck/2(m_BaudRate+1)=10us
    SPI_Reset(SPIx);											      //λģ
    SPI_Configuration(SPIx, &newStruct_SPI);					      //дṹ

    /*DMA*/
    /*ͨ*/
	DMA_InitTypeDef dmaNewStruct;
	DMA_Reset(DMA_COMx);
    dmaNewStruct.m_Number = BufferSize;                               //ݸ: BufferSize
    dmaNewStruct.m_Direction = DMA_PERIPHERAL_TO_MEMORY;              // DMA䷽赽ڴ
    dmaNewStruct.m_Priority = DMA_CHANNEL_TOP;					      // DMAͨȼȼ
    dmaNewStruct.m_PeripheralDataSize = DMA_DATA_WIDTH_8_BITS;        // λ 8λ
    dmaNewStruct.m_MemoryDataSize = DMA_DATA_WIDTH_8_BITS;            //ô洢λ:8λ
    dmaNewStruct.m_PeripheralInc = FALSE; 							  // ַģʽʹ: ֹ
    dmaNewStruct.m_MemoryInc = TRUE;								  // 洢ַģʽʹ: 
    dmaNewStruct.m_Channel = DMA_Rx;						          // DMAͨѡ:ͨ  RX
    dmaNewStruct.m_BlockMode = DMA_TRANSFER_BYTE;	                  // ݿ鴫ģʽֽڴ
    dmaNewStruct.m_LoopMode = TRUE;//FALSE;			                  // ѭģʽʹ: 
    dmaNewStruct.m_PeriphAddr = (uint32_t)&(SPIx->BUFR);      	      // ʼַ
    dmaNewStruct.m_MemoryAddr = (uint32_t)&Read_data;                 // ڴʼַ
    DMA_Configuration (DMA_COMx,&dmaNewStruct);                       //д

    SPI_Receive_DMA_INT_Enable (SPIx,TRUE);                           //DMA
	DMA_Channel_Enable (DMA_COMx, DMA_Rx, TRUE);					  //DMAͨʹ
	DMA_Finish_Transfer_INT_Enable(DMA_COMx,DMA_Rx,TRUE);		      //DMAж

	/*ͨ*/
	dmaNewStruct.m_Number = BufferSize; 							//ݸ: BufferSize
    dmaNewStruct.m_Direction = DMA_MEMORY_TO_PERIPHERAL;            // DMA䷽ڴ浽
    dmaNewStruct.m_Channel = DMA_Tx;						        // DMAͨѡ:ͨ  TX
    dmaNewStruct.m_LoopMode = FALSE;			                    // ѭģʽʹ: ֹ
    dmaNewStruct.m_PeriphAddr = (uint32_t)&(SPIx->BUFR);      	    // ʼַ
#if SPI_MASTER
    dmaNewStruct.m_MemoryAddr = (uint32_t)&Tx_master;               // ڴʼַ
#else
    dmaNewStruct.m_MemoryAddr = (uint32_t)&Tx_slave;                // ڴʼַ
#endif
    DMA_Configuration (DMA_COMx,&dmaNewStruct);				        //д

	SPI_Transmit_DMA_INT_Enable(SPIx,TRUE);							//DMA
    DMA_Channel_Enable (DMA_COMx, DMA_Tx, TRUE);				    //DMAͨʹ
	DMA_Finish_Transfer_INT_Enable(DMA_COMx,DMA_Tx,TRUE);		    //DMAж

	SPI_Cmd(SPIx,TRUE);											     //ʹSPIx
}
