/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: EXTLF
 *  :  V2.1
 *  :  20191116
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"


/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}





/**
  *  ͹ĶʱT0ʱʱá
  *   Periodµֵȡֵ16λ
  *     PrescalerEXTLFԤƵֵ
  *   ޡ
  */
void LPTIMER_T0_Config(uint32_t Period,uint32_t Prescaler)
{

	OSC_SCK_Source_Config(SCLK_SOURCE_EXTLF);                 //ѡEXTLFΪϵͳʱ

	OSC_Backup_Write_Read_Enable(TRUE);                       //ʹܱд

	PM_CCP0CLKLPEN_Enable(TRUE);                              //CCP0͹ʱʹ

	TIM_Reset(T0_SFR);										  //ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(T0_SFR,TRUE);			  //¿
	GPTIM_Updata_Enable(T0_SFR,TRUE);						  //øʹ
	GPTIM_Work_Mode_Config(T0_SFR,GPTIM_TIMER_MODE);		  //ʱģʽѡ
	GPTIM_Set_Counter(T0_SFR,0);							  //ʱֵ
	GPTIM_Set_Period(T0_SFR,Period);						  //ʱֵ
	GPTIM_Set_Prescaler(T0_SFR,Prescaler);				      //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(T0_SFR,GPTIM_COUNT_UP_DOWN_OUF);//-¼,жϱ־
	GPTIM_Clock_Config(T0_SFR,GPTIM_LFCLK);					  //ѡLFCLKʱ

	INT_Interrupt_Priority_Config(INT_T0,4,0);				  //ռȼ4,ȼ0
	GPTIM_Overflow_INT_Enable(T0_SFR,TRUE);					  //жʹ
	INT_Interrupt_Enable(INT_T0,TRUE);						  //жʹ
	INT_Clear_Interrupt_Flag(INT_T0);						  //жϱ־
	GPTIM_Cmd(T0_SFR,TRUE);									  //ʱʹ
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);			  //жԶջʹõֶ
	INT_All_Enable (TRUE);									  //ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

	OSC_Backup_Write_Read_Enable(FALSE);                      //ֹд


}


/**
  *  ⲿƵʱӳʼá
  *  : 
  *
  *   ޡ
  */
void OSC_EXTLF_Config(void)
{
	volatile unsigned int delay_C;
	/* enable INTLF  */
	OSC_INTLF_Software_Enable(TRUE);
	/* enable INTHF  */
	OSC_INTHF_Software_Enable(TRUE);  		  //INTHF need 200us starting time
	FLASH_CFG = 0xC7;                         //Flash confige default setting
    delay_C = 0xc8;
	while (delay_C--); //delay 200us
	OSC_SCK_Division_Config(SCLK_DIVISION_1); // clock division 1:1
	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF); //slect INTHF to be system clock;
	while (OSC_Get_INTHF_INT_Flag() != SET);

	/* Config the BKP area is enable, BKP register and data can be write and read */
	SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS);
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPWR_POS);


	PM_EXTLF_PIN_Selection_Config(PM_EXTLF_PIN2_IO_PORT); //ⲿƵ PH8PH9о
	OSC_EXTLF_Software_Enable(TRUE);//ⲿƵʹ
	delay_C = 0xc8;
	while (delay_C--); //delay 200us
	while (OSC_Get_EXTLF_INT_Flag() != SET);


	/************system clock must be PLL clock source!!!!***********/
	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF);  //slect EXTHF to be system clock;
    OSC_PLL_Input_Source_Config(SCLK_SOURCE_INTHF);        //slect EXTHF(16M) to be PLL clock;
    /************system clock must be PLL clock source!!!!***********/

	/* PLL frequency multiplier clock */
    OSC_PLL_Multiple_Value_Select(30,2,2);               //120MHZ

	OSC_PLL_Start_Delay_Config(PLL_START_DELAY_8192);
	OSC_PLL_Software_Enable(TRUE);
	OSC_PLL_RST();
	delay_C = 0x27f;
	while (delay_C--) ; //wait 1ms
	while (OSC_Get_PLL_INT_Flag() != SET);
	/* system clock */
	OSC_SCK_Division_Config(SCLK_DIVISION_1);   //DIVISION 1:1
	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);     //slect PLL to be system clock

	OSC_Clock_Failure_Check_Enable(TRUE);       //enable osc clock failure check;

	/* peripheral clock ;HFCLK*/
	OSC_HFCK_Division_Config(HFCK_DIVISION_1);
	OSC_HFCK_Source_Config(HFCK_SOURCE_INTHF);    //slect EXTHF to be HFCLK
	OSC_HFCK_Enable(TRUE);                        //enable HFCLK

	OSC_LFCK_Division_Config(LFCK_DIVISION_1);	// Low  frequency LFCK DIVISIN 1:1
	OSC_LFCK_Source_Config (LFCK_INPUT_EXTLF);  //slect EXTLF to be LFCLK
	OSC_LFCK_Enable (TRUE);					    //enable LFCLK


	OSC_SCLK_Output_Division_Config(SCLK_DIVISION_128);					//DIVISION 1/128
	OSC_SCLK_Output_Enable(TRUE);										//system clock out
	GPIO_Write_Mode_Bits(GPIOA_SFR,GPIO_PIN_MASK_0,GPIO_MODE_RMP);      //PA0 mask map
	GPIO_Pin_RMP_Config(GPIOA_SFR,GPIO_Pin_Num_0,GPIO_RMP_AF0_SYSTEM);	//output system clock from PA0
}

//
void main()
{
	/*ûɲοKF32L530_demoʵⲿƵùܡ
	 * ʹⲿ32.768KHZΪϵͳʱӣʹͨöʱT0T0ʱԴҲⲿƵ
	 * ʱT01һжϣPF0жϺзתSTATUS˸
	 *
	 * ͬʱⲿʱӹϼһйϵͳԶлڲƵʱӣϵͳ
	 *
	 * ע:Ҫʹܱ򣬲ñ˸λ״̬ʹⲿӦá
	 */
	/*ⲿƵ*/
	OSC_EXTLF_Config();  //32.768KHZʹ

	//PF0ʼߵƽ
	GPIOInit_Output_Config(GPIOF_SFR,GPIO_PIN_MASK_0);
	//͹Ķʱֵ ԤƵ
    LPTIMER_T0_Config(512,63); //ʱԴ32.768KHZ, ԤƵֵ1:64   512HZ488Σ1һж

	while(1)
	{

	}

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

