/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: DAC_TriangleWave
 *  :  V2.1
 *  :  20191116
 *  :  ChipON_AE/FAE_Group
 *
 ****************************************************************************************/
#include "system_init.h"

/**
  *   ͨöʱʼ
  *  : GPTIMx: ָʱڴṹָ룬
  *               ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/T18_SFR/
  *               T19_SFR/T20_SFR/T21_SFR
  *       PeriodµֵT20 T21ȡֵ32λݡʱȡֵ Ϊ16λ
  *   ޡ
  */
void GENERAL_TIMER_Tx_Config(GPTIM_SFRmap* GPTIMx,uint32_t Period)
{
//ͨöʱ Ϊģʽ TXIFѡSCLKʱԴԤƵΪ3
	TIM_Reset(GPTIMx);											  //ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);				  //¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);							  //øʹ
	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);			  //ʱģʽѡ
	GPTIM_Master_Mode_Config(GPTIMx,GPTIM_MASTER_TXIF_SIGNAL);    //ģʽѡTXIFΪ

	GPTIM_Set_Counter(GPTIMx,0);								  //ʱֵ
	GPTIM_Set_Period(GPTIMx,Period);							  //ʱֵ
	GPTIM_Set_Prescaler(GPTIMx,2);				    			  //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_DOWN_OUF);	  //-¼,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_SCLK);						  //ѡSCLKʱ
	GPTIM_Cmd(GPTIMx,TRUE);										  //ʱʹ

}




/**
  *   DACx ʼòѡ񴥷Դ
  *  :  DACx: ָDACڴṹָ룬ȡֵΪDAC0_SFRDAC1_SFR
   TriggerEvent: ¼ѡ     DAC_TRIGGER_T1_TRGO
	*					        DAC_TRIGGER_T3_TRGO
	*							DAC_TRIGGER_T5_TRGO
	*							DAC_TRIGGER_T9_TRGO
	*							DAC_TRIGGER_T14_TRGO
	*							DAC_TRIGGER_T15_TRGO
	*							DAC_TRIGGER_SOFTWARE_TRGO
	*							DAC_TRIGGER_T0_TRGO
	*							DAC_TRIGGER_T2_TRGO
	*							DAC_TRIGGER_T4_TRGO
	*							DAC_TRIGGER_T18_TRGO
	*							DAC_TRIGGER_T19_TRGO
	*							DAC_TRIGGER_T20_TRGO
	*							DAC_TRIGGER_T21_TRGO
  *   ޡ
  */
void DAC_Init_Config(DAC_SFRmap* DACx, uint32_t m_TriggerEvent)
{
//DACʹǲѡSCLKΪʱԴڲοѹģΪοѹ
	static uint32_t ReferenceVoltage=0;
	DAC_Reset(DACx);                                //λDACʹDACʱ

	DAC_InitTypeDef DAC_InitStructure;
	DAC_Struct_Init(&DAC_InitStructure);
	DAC_InitStructure.m_TriggerEnable=TRUE;                 //DACͨʹ
	DAC_InitStructure.m_TriggerEvent = m_TriggerEvent;      //DACͨ¼
	DAC_InitStructure.m_TriggerDMAEnable = FALSE;           //DACDMAʹ
	DAC_InitStructure.m_Wave = DAC_WAVE_TRIANGLE;           //ʹǲ
	DAC_InitStructure.m_Mas = DAC_TRIANGLE_AMPLITUDE_4095;  //ֵѡ
	DAC_InitStructure.m_Clock = DAC_CLK_SCLK;               //DACʱԴ
	DAC_InitStructure.m_ReferenceVoltage = DAC_RFS_1P2V;    //DACοѹ
	DAC_InitStructure.m_OutputBuffer = TRUE;                //
	DAC_InitStructure.m_OutputPin = DAC_OUTPUT_PIN_0;       // DAC1 ŶӦΪPA0
	DAC_InitStructure.m_Output = 4095;
    DAC_Configuration(DACx,&DAC_InitStructure);

    ReferenceVoltage =DAC_InitStructure.m_ReferenceVoltage;

	if((ReferenceVoltage == DAC_RFS_2V)||(ReferenceVoltage == DAC_RFS_1P2V))
	{
		OSC_Backup_Write_Read_Enable (TRUE);    //ñĴд
		PM_Reference_Voltage_Enable (TRUE);     //ʹܲοѹģ
	}
	DAC_Cmd(DACx,TRUE);//DACʹ
}


//
void main()
{
	/*ûɲοKF32L530_demoʵDAC1 ǲùܡ
	    DAC1ǲԴѡʱT20Ӧ
     *ʾԲPA0Ϊǲź
     *עѡPA0ΪDACӳܣڲοѹʱҪ򿪱д
	 */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//ʹöʱT20
	GENERAL_TIMER_Tx_Config(T20_SFR,4000); //T20ֵ Ϊ4000

	/*DAC1 ǲʼѡT20Դ*/
	DAC_Init_Config(DAC1_SFR,DAC_TRIGGER_T20_TRGO);  //PA0ǲ
    while(1)
    {
    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

