/**
  ******************************************************************************
  * ļ  USART_user.c
  *     ChipON_AE/FAE_Group
  *     2019-10-19
  *     ļṩ첽ú
  *          + ڷ
  *          + 첽
  *          + ͬ
  *          + ڽжʹ
  ******************************************************************************/
#include "system_init.h"


/**
  *    IOӳ䣬PB2uart3_rx,PA3uart3_tx
  *    
  *    
  */
void GPIO_USART()
{
	GPIO_Write_Mode_Bits(GPIOB_SFR ,GPIO_PIN_MASK_2, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Write_Mode_Bits(GPIOA_SFR ,GPIO_PIN_MASK_3, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Pin_RMP_Config (GPIOB_SFR, GPIO_Pin_Num_2, GPIO_RMP_AF6_USART3);	   //ӳΪUSART3
	GPIO_Pin_RMP_Config (GPIOA_SFR,	GPIO_Pin_Num_3, GPIO_RMP_AF6_USART3);       //ӳΪUSART3
	GPIO_Pin_Lock_Config (GPIOB_SFR ,GPIO_PIN_MASK_2, TRUE);                   //
	GPIO_Pin_Lock_Config (GPIOA_SFR ,GPIO_PIN_MASK_3, TRUE);                   //
}

/**
  *    ڷ
  *    USARTx:   ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Databuf   ָݵָ
  *      length      ͵ĳ
  *    
  */
void USART_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length)
{
	uint32_t i;
	for(i=0;i<length;i++)
	{
		//ڷ
		USART_SendData(USARTx,Databuf[i]);
		//ɱ־
		while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	}
}

void USART_Send_byte(USART_SFRmap* USARTx, uint8_t Databuf)
{
	//ڷ
	USART_SendData(USARTx,Databuf);
	//ɱ־
	while(!USART_Get_Transmitter_Empty_Flag(USARTx));
}

/**
  *   첽ȫ˫(Ĭ8bitշʹ  ȫ˫ 9600)
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_Async_config(USART_SFRmap *USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
    USART_InitStructure.m_Mode=USART_MODE_FULLDUPLEXASY;                        //ȫ˫
    USART_InitStructure.m_TransferDir=USART_DIRECTION_FULL_DUPLEX;              //䷽
    USART_InitStructure.m_WordLength=USART_WORDLENGTH_8B;                       //8λ
    USART_InitStructure.m_StopBits=USART_STOPBITS_1;                            //1λֹͣλ
    USART_InitStructure.m_BaudRateBRCKS=USART_CLK_HFCLK;                        //ڲƵʱΪ USARTʷʱ

    /*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
    //4800    z:208    x:0    y:0
    //9600    z:104    x:0    y:0
    //19200   z:52     x:0    y:0
    //115200  z:8      x:1    y:13
    //9600
    USART_InitStructure.m_BaudRateInteger=104;         //USARTzȡֵΪ0~65535
    USART_InitStructure.m_BaudRateNumerator=0;         //USARTСӲxȡֵΪ0~0xF
    USART_InitStructure.m_BaudRateDenominator=0;       //USARTСĸyȡֵΪ0~0xF

	USART_Reset(USARTx);                                       //USARTxλ
	USART_Configuration(USARTx,&USART_InitStructure);          //USARTx
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);                //USARTxBUF
	USART_RESHD_Enable (USARTx, TRUE);						   //ʹRESHDλ
	USART_Cmd(USARTx,TRUE);                                    //USARTxʹ
}

/**
  *    ڰ˫ͬ(Ĭģʽ9bitͣ9600)
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_Sync_config(USART_SFRmap* USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
    USART_InitStructure.m_Mode=USART_MODE_HALFDUPLEXSYN;                        //˫
    USART_InitStructure.m_HalfDuplexClkSource=USART_MASTER_CLOCKSOURCE_INTER;   //ģʽ
    USART_InitStructure.m_TransferDir=USART_DIRECTION_TRANSMIT;                 //䷽""
    USART_InitStructure.m_WordLength=USART_WORDLENGTH_9B;                       //9λ
    USART_InitStructure.m_Parity=USART_PARITY_ODD;                              //У
    USART_InitStructure.m_BaudRateBRCKS=USART_CLK_HFCLK;                        //ڲƵʱΪ USARTʷʱ

    /*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
    //4800    z:208    x:0    y:0
    //9600    z:104    x:0    y:0
    //19200   z:52     x:0    y:0
    //115200  z:8      x:1    y:13
    //9600
    USART_InitStructure.m_BaudRateInteger=104;         //USARTzȡֵΪ0~65535
    USART_InitStructure.m_BaudRateNumerator=0;         //USARTСӲxȡֵΪ0~0xF
    USART_InitStructure.m_BaudRateDenominator=0;       //USARTСĸyȡֵΪ0~0xF

	USART_Reset(USARTx);                                       //USARTxλ
	USART_Configuration(USARTx,&USART_InitStructure);          //USARTx
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);                //USARTxBUF
	USART_RESHD_Enable (USARTx, TRUE);						   //ʹRESHDλ
	USART_Cmd(USARTx,TRUE);                                    //USARTxʹ
}


/**
  *    ڽж
  *    USARTx:ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Peripheral:ںжţȡֵΧΪ
  *                 öInterruptIndexеж
  *    
  */
void USART_ReceiveInt_config(USART_SFRmap *USARTx,InterruptIndex Peripheral)
{
	USART_RDR_INT_Enable(USARTx,TRUE);
	INT_Interrupt_Enable(Peripheral,TRUE);
	INT_All_Enable(TRUE);
}
