/**
  ******************************************************************************
  * ļ  kf32ls_basic_btim.c
  *     ChipON_AE/FAE_Group
  *     V3.0.0
  *     2021-08-20
  *     ļṩ˴ӿ(SPI)蹦ܺ
  *          + ӿ(SPI)ʼ
  *          + ӿ(SPI)ú
  *          + ӿ(SPI)жϹ
  *
  *********************************************************************
  */

#include "kf32ls_basic_spi.h"
#include "kf32ls_basic_rst.h"
#include "kf32ls_basic_pclk.h"


/* SPIʱ˽ж ----------------------------------------------------*/
/* SPIx_CTLRĴSPIʼ */
#define SPI_CTLR_SPI_INIT_MASK          (SPI_CTLR_SPIMS \
                                       | SPI_CTLR_SPICKS \
                                       | SPI_CTLR_SPIDS \
                                       | SPI_CTLR_SPICKP \
                                       | SPI_CTLR_SPICKE \
                                       | SPI_CTLR_SPIBS )

/* SPIx_CTLRĴI2Sʼ */
#define SPI_CTLR_I2S_INIT_MASK          (SPI_CTLR_I2SMC \
                                       | SPI_CTLR_I2SSS \
                                       | SPI_CTLR_PCMS \
                                       | SPI_CTLR_I2SCKS \
                                       | SPI_CTLR_PCMCKP )


/**
  *   ##### ӿ(SPI)ʼ #####
  */
/**
  *   SPI踴λ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   ޡ
  */
void
SPI_Reset(SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
#ifdef KF32LS_Periph_spi0
    if (SPIx == SPI0_SFR)
    {
       RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_SPI0RST, TRUE);
       RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_SPI0RST, FALSE);
       PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_SPI0CLKEN, TRUE);
    }
#endif
#ifdef KF32LS_Periph_spi1
    if (SPIx == SPI1_SFR)
    {
       RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_SPI1RST, TRUE);
       RST_CTL1_Peripheral_Reset_Enable(RST_CTL1_SPI1RST, FALSE);
       PCLK_CTL1_Peripheral_Clock_Enable(PCLK_CTL1_SPI1CLKEN, TRUE);
    }
#endif
#ifdef KF32LS_Periph_spi2
    if (SPIx == SPI2_SFR)
    {
       RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_SPI2RST, TRUE);
       RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_SPI2RST, FALSE);
       PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_SPI2CLKEN, TRUE);
    }
#endif
#ifdef KF32LS_Periph_spi3
    if (SPIx == SPI3_SFR)
    {
       RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_SPI3RST, TRUE);
       RST_CTL3_Peripheral_Reset_Enable(RST_CTL3_SPI3RST, FALSE);
       PCLK_CTL3_Peripheral_Clock_Enable(PCLK_CTL3_SPI3CLKEN, TRUE);
    }
#endif
}

/**
  *   SPIģʽʼá
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       SPIInitStruct: SPIЭϢṹָ롣
  *   ޡ
  */
void
SPI_Configuration(SPI_SFRmap* SPIx, SPI_InitTypeDef* spiInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_MODE(spiInitStruct->m_Mode));
    CHECK_RESTRICTION(CHECK_SPI_CLK(spiInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_SPI_FIRST_BIT(spiInitStruct->m_FirstBit));
    CHECK_RESTRICTION(CHECK_SPI_CKP(spiInitStruct->m_CKP));
    CHECK_RESTRICTION(CHECK_SPI_CKE(spiInitStruct->m_CKE));
    CHECK_RESTRICTION(CHECK_SPI_DATASIZE(spiInitStruct->m_DataSize));

    /*----------------- SPI_CTLRĴ  -----------------*/
    /* ݽṹԱm_ModeSPIMSλ */
    /* ݽṹԱm_ClockSPICKSλ */
    /* ݽṹԱm_FirstBitSPIDSλ */
    /* ݽṹԱm_CKPSPICKPλ */
    /* ݽṹԱm_CKESPICKEλ */
    /* ݽṹԱm_DataSizeSPIBSλ */
    tmpreg = ((spiInitStruct->m_Mode)      \
            | (spiInitStruct->m_Clock)     \
            | (spiInitStruct->m_FirstBit)  \
            | (spiInitStruct->m_CKP)       \
            | (spiInitStruct->m_CKE)       \
            | (spiInitStruct->m_DataSize));
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_SPI_INIT_MASK, tmpreg);

    /*----------------- SPI_BRGRĴ  -----------------*/
    /* ݽṹԱm_BaudRateSPIBRGλ */
    tmpreg = (uint32_t)spiInitStruct->m_BaudRate << SPI_BRGR_SPIBRG0_POS;
    SPIx->BRGR = SFR_Config (SPIx->BRGR, ~SPI_BRGR_SPIBRG, tmpreg);
}

/**
  *   I2Sģʽʼá
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       I2SInitStruct:I2SЭϢṹָ롣
  *   ޡ
  */
void
I2S_Configuration(SPI_SFRmap* SPIx, I2S_InitTypeDef* i2sInitStruct)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_I2S_MODE(i2sInitStruct->m_Mode));
    CHECK_RESTRICTION(CHECK_I2S_STANDARD(i2sInitStruct->m_Standard));
    CHECK_RESTRICTION(CHECK_I2S_PCM(i2sInitStruct->m_PCM));
    CHECK_RESTRICTION(CHECK_I2S_CLK(i2sInitStruct->m_Clock));
    CHECK_RESTRICTION(CHECK_I2S_CKP(i2sInitStruct->m_CKP));

    /*----------------- SPIx_CTLRĴ -----------------*/
    /* ݽṹԱm_ModeI2SMCλ */
    /* ݽṹԱm_STANDARDI2SSSλ */
    /* ݽṹԱm_PCMPCMSλ */
    /* ݽṹԱm_CLKCHLENλ */
    /* ݽṹԱm_CPOLPCMCKPλ */
    tmpreg = ((i2sInitStruct->m_Mode)     \
            | (i2sInitStruct->m_Standard) \
            | (i2sInitStruct->m_PCM)      \
            | (i2sInitStruct->m_Clock)    \
            | (i2sInitStruct->m_CKP));
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_I2S_INIT_MASK , tmpreg);

    /*----------------- SPI_BRGRĴ  -----------------*/
    /* ݽṹԱm_PrescalerI2SDIVλ */
    tmpreg = (uint32_t)i2sInitStruct->m_Prescaler << SPI_BRGR_I2SDIV0_POS;
    SPIx->BRGR = SFR_Config (SPIx->BRGR, ~SPI_BRGR_I2SDIV, tmpreg);
}

/**
  *   ʼSPIЭϢṹ塣
  *   SPI_InitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
SPI_Struct_Init(SPI_InitTypeDef* SPI_InitStruct)
{
    /* ʼ SPIģʽѡ */
    SPI_InitStruct->m_Mode = SPI_MODE_SLAVE;
    /* ʼSPIʱѡ */
    SPI_InitStruct->m_Clock = SPI_CLK_HFCLK;
    /* ʼ SPIݷѡλ */
    SPI_InitStruct->m_FirstBit = SPI_FIRSTBIT_MSB;
    /* ʼ SPIʱӼѡ */
    SPI_InitStruct->m_CKP = SPI_CKP_LOW;
    /* ʼ SPIʱӱѡ */
    SPI_InitStruct->m_CKE = SPI_CKE_1EDGE;
    /* ʼ SPIλģʽѡ */
    SPI_InitStruct->m_DataSize = SPI_DATASIZE_8BITS;
    /* ʼ SPIû */
    SPI_InitStruct->m_BaudRate = 0;
}

/**
  *   ʼI2SЭϢṹ塣
  *   I2S_InitStruct: ָʼĽṹָ롣
  *   ޡ
  */
void
I2S_Struct_Init(I2S_InitTypeDef* I2S_InitStruct)
{
    /* ʼ I2Sģʽѡ */
    I2S_InitStruct->m_Mode = I2S_MODE_SLAVE_TX;
    /* ʼ I2S׼ѡ */
    I2S_InitStruct->m_Standard = I2S_STANDARD_PHILLIPS;
    /* ʼ PCM֡ͬ */
    I2S_InitStruct->m_PCM = I2S_PCM_LONG;
    /* ʼ I2SʱӷƵѡ */
    I2S_InitStruct->m_Clock = I2S_CLK_BAUDRATE;
    /* ʼ PCMģʽʱӼѡ */
    I2S_InitStruct->m_CKP = I2S_CKP_LOW;
    /* ʼ I2SԤƵ */
    I2S_InitStruct->m_Prescaler = 0;
}
/**
  *   ##### ӿ(SPI)ʼ #####
  */


/**
  *   ##### ӿ(SPI)ú #####
  */
/**
  *   SPIģʹλ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPIʹλϢȡֵΪ TRUE  FALSE
  *   ޡ
  */
void
SPI_Cmd (SPI_SFRmap* SPIx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*----------------- SPI_CTLRĴSPIENλ  -----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPI */
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPIEN_POS);
    }
    else
    {
        /* ֹSPI */
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPIEN_POS);
    }
}

/**
  *   I2Sѡλ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: I2SѡλϢȡֵΪ TRUE  FALSE
  *       TRUEѡI2Sģʽ
  *       FALSE:ѡSPIģʽ
  *   ޡ
  */
void
I2S_Mode_Select(SPI_SFRmap* SPIx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*----------------- SPI_CTLRĴI2SMODλ  -----------------*/
    if (NewState != FALSE)
    {
        /* ʹI2S */
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SMOD_POS);
    }
    else
    {
        /* ֹI2S */
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SMOD_POS);
    }
}

/**
  *   ȡSPI_I2Sݡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   32λݡ
  */
uint32_t
SPI_I2S_ReceiveData (SPI_SFRmap* SPIx)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*----------------- ȡSPI_BUFRĴ  -----------------*/
    tmpreg = SPIx->BUFR;

    return tmpreg;
}

/**
  *   SPI_I2S32λݡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   ޡ
  */
void
SPI_I2S_SendData32(SPI_SFRmap* SPIx, uint32_t Data)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*----------------- SPI_BUFRĴ  -----------------*/
    SPIx->BUFR = Data;
}
/**
  *   SPI_I2S8λݡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   ޡ
  */
void
SPI_I2S_SendData8(SPI_SFRmap* SPIx, uint8_t Data)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*----------------- SPI_BUFRĴ  -----------------*/
    SPIx->BUFR = Data;
}
/**
  *   SPIʼĴ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       BAUDRATE: ѡȡֵΪ0~65535
  *   ޡ
  */
void
SPI_BaudRate_Config (SPI_SFRmap* SPIx, uint16_t BAUDRATE)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- SPI_CTLRĴI2SSSλ ----------------*/
    tmpreg = (uint32_t)BAUDRATE<< SPI_BRGR_SPIBRG0_POS;
    SPIx->BRGR = SFR_Config (SPIx->BRGR, ~SPI_BRGR_SPIBRG, tmpreg);
}

/**
  *   I2SԤƵĴ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       DIV: I2SԤƵѡȡֵΪ0~255
  *   ޡ
  */
void
I2S_DIV_Config (SPI_SFRmap* SPIx,uint8_t DIV)
{
    uint32_t tmpreg = 0;

    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- SPI_CTLRĴλI2SSS ----------------*/
    tmpreg = (uint32_t)DIV << SPI_BRGR_I2SDIV0_POS;
    SPIx->BRGR = SFR_Config (SPIx->BRGR, ~SPI_BRGR_I2SDIV, tmpreg);
}

/**
  *   SPIͬж˿ģʽѡλ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       MODE: ģʽѡȡֵΧΪ
  *               SPI_MODE_MASTER_CLKDIV4: SPIģʽʱ = ʱ/4
  *               SPI_MODE_MASTER_CLKDIV16: SPIģʽʱ = ʱ/16
  *               SPI_MODE_MASTER_CLKDIV64: SPIģʽʱ = ʱ/64
  *               SPI_MODE_MASTER_T2DIV2: SPIģʽʱ = TIMER2/2
  *               SPI_MODE_SLAVE: SPIӶģʽʱ = SCKšʹSSſ
  *   ޡ
  */
void
SPI_MODE_Config (SPI_SFRmap* SPIx,uint32_t MODE)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_MODE(MODE));

    /*---------------- SPI_CTLRĴSPIMSλ ----------------*/
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_SPIMS, MODE);
}

/**
  *   SPIʱѡĴ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       ClockSource: ģʽѡȡֵΧΪ
  *                      SPI_CLK_SCLK  :ѡSCLKΪSPIʱ
  *                      SPI_CLK_HFCLK :ѡHFCLKΪSPIʱ
  *                      SPI_CLK_LFCLK :ѡLFCLKΪSPIʱ
  *   ޡ
  */
void
SPI_CLK_Config (SPI_SFRmap* SPIx,uint32_t ClockSource)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_CLK(ClockSource));

    /*---------------- SPI_CTLRĴSPIMSλ ----------------*/
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_SPICKS, ClockSource);
}

/**
  *   SPIݷѡλ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       DataDirection: SPIݷȡֵΪ
  *                        SPI_FIRSTBIT_MSB:λǰ
  *                        SPI_FIRSTBIT_LSB:λǰ
  *   ޡ
  */
void
SPI_Data_Direction_Config(SPI_SFRmap* SPIx,uint32_t DataDirection)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_FIRST_BIT(DataDirection));

    /*---------------- SPI_CTLRĴSPIDSλ ----------------*/
    if (DataDirection != SPI_FIRSTBIT_LSB)
    {
        /* MSBλǰ */
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPIDS_POS);
    }
    else
    {
        /* LSBλǰ */
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPIDS_POS);
    }
}

/**
  *   SPIʱӼѡλ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       Polarity: SPIʱӼԣȡֵΪ
  *                   SPI_CKP_LOW:״̬ʱʱΪ͵ƽ
  *                   SPI_CKP_HIGH:״̬ʱʱΪߵƽ
  *   ޡ
  */
void
SPI_Clock_Polarity_Config (SPI_SFRmap* SPIx,uint32_t Polarity)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_CKP(Polarity));

    /*---------------- SPI_CTLRĴSPICKPλ ----------------*/
    if (Polarity != SPI_CKP_LOW)
    {
        /* ״̬ʱʱΪߵƽ */
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPICKP_POS);
    }
    else
    {
        /* ״̬ʱʱΪ͵ƽ */
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPICKP_POS);
    }
}

/**
  *   SPIʱӱѡλ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       ClockEdge: SPIʱӱأȡֵΪ
  *                    SPI_CKE_2EDGE:ڵ2ʱأ½ݣ
  *                    SPI_CKE_1EDGE:ڵ1ʱأ½ݡ
  *   ޡ
  */
void
SPI_Clock_Edge_Config (SPI_SFRmap* SPIx,uint32_t ClockEdge)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_CKE(ClockEdge));

    /*---------------- SPI_CTLRĴSPICKEλ ----------------*/
    if (ClockEdge != SPI_CKE_1EDGE)
    {
        /* ڵ2ʱأ½ */
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPICKE_POS);
    }
    else
    {
        /* ڵ1ʱأ½ */
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_SPICKE_POS);
    }
}

/**
  *   SPIλģʽѡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       DataSize: ģʽѡȡֵΧΪ
  *                   SPI_DATASIZE_8BITS  :SPIʹ8λģʽ֧I2Sģʽ
  *                   SPI_DATASIZE_16BITS :SPIʹ16λģʽ
  *                   SPI_DATASIZE_32BITS :SPIʹ32λģʽ
  *   ޡ
  */
void
SPI_BIT_SELECT_Config(SPI_SFRmap* SPIx,uint32_t DataSize)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_SPI_DATASIZE(DataSize));

    /*---------------- SPI_CTLRĴSPIBSλ ----------------*/
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_SPIBS, DataSize);
}

/**
  *   I2Sģʽá
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       Mode: ģʽѡȡֵΧΪ
  *               I2S_MODE_SLAVE_TX   :豸ģʽ
  *               I2S_MODE_SLAVE_RX   :豸ģʽ
  *               I2S_MODE_MASTER_TX  :豸ģʽ
  *               I2S_MODE_MASTER_RX  :豸ģʽ
  *   ޡ
  */
void
SPI_I2S_MODE_Config (SPI_SFRmap* SPIx,uint32_t Mode)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_I2S_MODE(Mode));

    /*---------------- SPI_CTLRĴI2SMCλ ----------------*/
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_I2SMC, Mode);
}

/**
  *   I2S׼ѡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       Standard: ģʽѡȡֵΧΪ
  *                   I2S_STANDARD_PHILLIPS :I2Sֱ׼
  *                   I2S_STANDARD_MSB      :ֽڶ׼Ҷ룩
  *                   I2S_STANDARD_LSB      :ֽڶ׼룩
  *                   I2S_STANDARD_PCM      :PCM׼
  *   ޡ
  */
void
SPI_I2S_STANDARD_Config(SPI_SFRmap* SPIx,uint32_t Standard)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_I2S_STANDARD(Standard));

    /*---------------- SPI_CTLRĴI2SSSλ ----------------*/
    SPIx->CTLR = SFR_Config (SPIx->CTLR, ~SPI_CTLR_I2SSS, Standard);
}

/**
  *   I2S PCM֡ͬ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: PCM֡ͬãȡֵΪ
  *                   I2S_PCM_LONG: ֡ͬ
  *                   I2S_PCM_SHORT:֡ͬ
  *   ޡ
  */
void
SPI_PCM_Config (SPI_SFRmap* SPIx,uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_I2S_PCM(NewState));

    /*---------------- SPI_CTLRĴPCMSλ ----------------*/
    if (NewState != I2S_PCM_SHORT)
    {
        /* ֡ͬ*/
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_PCMS_POS);
    }
    else
    {
        /*֡ͬ*/
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_PCMS_POS);
    }
}

/**
  *   I2S ģʽʱӷƵѡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: ʱӷƵãȡֵΪ
  *                   I2S_CLK_BAUDRATE:ʣ
  *                   I2S_CLK_BAUDRATEDIV2:/2
  *   ޡ
  */
void
SPI_CHLEN_Config (SPI_SFRmap* SPIx,uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_I2S_CLK(NewState));

    /*---------------- SPI_CTLRĴCHLENλ ----------------*/
    if (NewState == I2S_CLK_BAUDRATEDIV8)
    {
        /* /8*/
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SCKS0_POS);
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SCKS1_POS);
    }
    else if(NewState == I2S_CLK_BAUDRATEDIV4)
    {
        /*/4*/
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SCKS0_POS);
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SCKS1_POS);
    }
    else
    {
    	/* */
    	SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SCKS0_POS);
    	SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_I2SCKS1_POS);
    }
}

/**
  *   PCMģʽʱӼѡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: PCMģʽʱӼԣȡֵΪ
  *                   I2S_CKP_HIGH: PCMʱ½طͣ
  *                   I2S_CKP_LOW:  PCMʱط͡
  *   ޡ
  */
void
SPI_PCM_CLOCK_Polarity_Config(SPI_SFRmap* SPIx,uint32_t NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_I2S_CKP(NewState));

    /*---------------- SPI_CTLRĴPCMCKPλ ----------------*/
    if (NewState != I2S_CKP_LOW)
    {
        /* PCMʱ½ط*/
        SFR_SET_BIT_ASM(SPIx->CTLR, SPI_CTLR_PCMCKP_POS);
    }
    else
    {
        /*PCMʱط*/
        SFR_CLR_BIT_ASM(SPIx->CTLR, SPI_CTLR_PCMCKP_POS);
    }
}

/**
  *   豸ʱʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: 豸ʱʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_MAIN_CLOCK_OUT_Enable (SPI_SFRmap* SPIx,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_BRGRĴMCKENλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹMCK*/
        SFR_SET_BIT_ASM(SPIx->BRGR, SPI_BRGR_MCKEN_POS);
    }
    else
    {
        /*δʹMCK*/
        SFR_CLR_BIT_ASM(SPIx->BRGR, SPI_BRGR_MCKEN_POS);
    }
}
/**
  *   ##### ӿ(SPI)ú #####
  */


/**
  *   ##### ӿ(SPI)жϹ #####
  */
/**
  *   SPIжʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPIжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_Receive_Overflow_INT_Enable (SPI_SFRmap* SPIx,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴROVFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPIж */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_ROVFIE_POS);
    }
    else
    {
        /* ֹSPIж */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_ROVFIE_POS);
    }
}

/**
  *   SPIжʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPIжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_Transmit_Overflow_INT_Enable (SPI_SFRmap* SPIx,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴTOVFIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPIж */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_TOVFIE_POS);
    }
    else
    {
        /* ֹSPIж */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_TOVFIE_POS);
    }
}

/**
  *   SPI RBUFΪжʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPI RBUFΪжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_RNEIE_INT_Enable (SPI_SFRmap* SPIx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴRNEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPI RBUFΪж */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_RNEIE_POS);
    }
    else
    {
        /* ֹSPI RBUFΪж */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_RNEIE_POS);
    }
}

/**
  *   SPI TBUFΪжʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPI TBUFΪжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_TNEIE_INT_Enable (SPI_SFRmap* SPIx,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴTNEIEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPI TBUFΪж */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_TNEIE_POS);
    }
    else
    {
        /* ֹSPI TBUFΪж */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_TNEIE_POS);
    }
}


/**
  *   SPIDMAжʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPIDMAжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_Receive_DMA_INT_Enable (SPI_SFRmap* SPIx,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴSRCDEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPIDMAж */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_SRCDE_POS);
    }
    else
    {
        /* ֹSPIDMAж */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_SRCDE_POS);
    }
}

/**
  *   SPIDMAжʹܡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPIDMAжʹ״̬ȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_Transmit_DMA_INT_Enable (SPI_SFRmap* SPIx,FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴSTXDEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ʹSPIDMAж */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_STXDE_POS);
    }
    else
    {
        /* ֹSPIDMAж */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_STXDE_POS);
    }
}

/**
  *   SPIѡ
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *       NewState: SPIѡȡֵΪTRUE  FALSE
  *   ޡ
  */
void
SPI_Transmit_CHSIDE_INT_Enable (SPI_SFRmap* SPIx, FunctionalState NewState)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));
    CHECK_RESTRICTION(CHECK_FUNCTIONAL_STATE(NewState));

    /*---------------- SPI_STRĴCHSIDEλ ----------------*/
    if (NewState != FALSE)
    {
        /* ڷ͵ */
        SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_CHSIDE_POS);
    }
    else
    {
        /* ڷ͵ */
        SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_CHSIDE_POS);
    }
}

/**
  *   ȡSPIæ״̬ 
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   1: SPIڷݣ
  *       0: SPIûڷݡ
  */
FlagStatus
SPI_Get_BUSY_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- ȡSPI_STRĴSPIBUSYλ ----------------*/
    if ((SPIx->STR) & SPI_STR_SPIBUSY)
    {
        /* SPIڷ */
        return SET;
    }
    else
    {
        /* SPIûڷ */
        return RESET;
    }
}

/**
  *   ȡSPIжϱ־״̬ 
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   1: SPI
  *       0: SPIûн
  */
FlagStatus
SPI_Get_Receive_Overflow_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- ȡSPI_STRĴROVFIFλ ----------------*/
    if (SPIx->STR & SPI_STR_ROVFIF)
    {
        /* SPI */
        return SET;
    }
    else
    {
        /* SPIûн */
        return RESET;
    }
}


/**
  *   ȡSPI־״̬ 
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   1: SPI
  *       0: SPIûв
  */
FlagStatus
SPI_Get_Transmit_Overflow_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- ȡSPI_STRĴTOVFIFλ ----------------*/
    if (SPIx->STR & SPI_STR_TOVFIF)
    {
        /* SPI */
        return SET;
    }
    else
    {
        /* SPIûв */
        return RESET;
    }
}

/**
  *   ȡSPIBUFδ״̬ 
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   1: SPIBUFΪգ
  *       0: SPIBUFΪա
  */
FlagStatus
SPI_Get_Receive_Buf_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- ȡSPI_STRĴRNEλ ----------------*/
    if (SPIx->STR & SPI_STR_RNE)
    {
        /* SPIBUFΪ */
        return SET;
    }
    else
    {
        /* SPIBUFΪ */
        return RESET;
    }
}

/**
  *   ȡSPIBUFδ״̬ 
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   1: SPIBUFΪգ
  *       0: SPIBUFΪա
  */
FlagStatus
SPI_Get_Transmit_Buf_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- ȡSPI_STRĴTNEλ ----------------*/
    if (SPIx->STR & SPI_STR_TNE)
    {
        /* SPIBUFΪ */
        return SET;
    }
    else
    {
        /* SPIBUFΪ */
        return RESET;
    }
}

/**
  *   SPIжϱ־
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   ޡ
  */
void
SPI_Clear_Receive_Overflow_INT_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- SPI_STRĴROVFICλ ----------------*/
    SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_ROVFIC_POS);
    while(SPIx->STR & SPI_STR_ROVFIF);
    SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_ROVFIC_POS);
}

/**
  *   SPIжϱ־
  *   SPIx: ָSPIڴṹָ룬ȡֵΪSPI0_SFR~SPI3_SFR
  *   ޡ
  */
void
SPI_Clear_Transmit_Overflow_INT_Flag (SPI_SFRmap* SPIx)
{
    /* У */
    CHECK_RESTRICTION(CHECK_SPI_ALL_PERIPH(SPIx));

    /*---------------- SPI_STRĴTOVFICλ ----------------*/
    SFR_SET_BIT_ASM(SPIx->STR, SPI_STR_TOVFIC_POS);
    while(SPIx->STR & SPI_STR_TOVFIF);
    SFR_CLR_BIT_ASM(SPIx->STR, SPI_STR_TOVFIC_POS);
}
/**
  *   ##### ӿ(SPI)жϹ #####
  */
